------------------------------------------------------------------------------------------------------
-- Totemus
--
-- Maintainer: Poolpy
--
-- Based on Ideas by:
--   Venantes by Zirah (http://www.wowinterface.com/downloads/info6155-Venantes.html)
--   Necrosis LdC by Lomig and Nyx (http://necrosis.larmes-cenarius.net)
--   Original Necrosis Idea : Infernal (http://www.revolvus.com/games/interface/necrosis/)
------------------------------------------------------------------------------------------------------

-- localisation
local L = AceLibrary('AceLocale-2.2'):new('Totemus');
-- timer functions
local metro = AceLibrary("Metrognome-2.0");

-- configuration
function TotemusConfig_Toggle()
    if InCombatLockdown() then
		DEFAULT_CHAT_FRAME:AddMessage(L['MSG_INCOMBAT']);
        return;
    end
    -- load configuration dialog
	local loaded, message = LoadAddOn('TotemusOptions');
	if (loaded) then
		PlaySound('igMainMenuOpen');
		if (not TotemusOptions.initialized) then
			TotemusOptions:Initialize();
			TotemusOptions.initialized = true;
			ShowUIPanel(TotemusOptionsFrame);
		elseif (TotemusOptionsFrame:IsVisible()) then
			HideUIPanel(TotemusOptionsFrame);
		else
                                                      TotemusOptions:UpdateData();
			ShowUIPanel(TotemusOptionsFrame);
		end
	else
		PlaySound('TellMessage');
        if message ~= nil then
            DEFAULT_CHAT_FRAME:AddMessage(L['LOAD_ERROR']..': '..message);
        else
            DEFAULT_CHAT_FRAME:AddMessage(L['LOAD_ERROR']);        
        end
	end
end

-- If the Debug library is available then use it

if AceLibrary:HasInstance('AceDebug-2.0') then
	Totemus = AceLibrary('AceAddon-2.0'):new(
        'AceConsole-2.0', 'AceEvent-2.0', 'AceDB-2.0', 'AceDebug-2.0', 
        'SphereCore-2.0', 'SphereButtons-2.0', 'SphereInventory-2.0'
    );
else
	Totemus = AceLibrary('AceAddon-2.0'):new(
        'AceConsole-2.0', 'AceEvent-2.0', 'AceDB-2.0', 
        'SphereCore-2.0', 'SphereButtons-2.0', 'SphereInventory-2.0'
    );
end

TOTEMUS_SPELLS = {  
    ['SHAMAN_BUFF_ROCK'] = 'Rockbiter Weapon',
    ['SHAMAN_BUFF_FLAME'] = 'Flametongue Weapon',
    ['SHAMAN_BUFF_FROST'] = 'Frostbrand Weapon',
    ['SHAMAN_BUFF_WIND'] = 'Windfury Weapon',

    ['SHAMAN_TERRE_EARTHBIND'] = 'Earthbind Totem',
    ['SHAMAN_TERRE_STONECLAW'] = 'Stoneclaw Totem',
    ['SHAMAN_TERRE_STRENGHEARTH'] = 'Strength of Earth Totem',
    ['SHAMAN_TERRE_STONESKIN'] = 'Stoneskin Totem',
    ['SHAMAN_TERRE_TREMOR'] = 'Tremor Totem',
    ['SHAMAN_TERRE_EARTHELEM'] = 'Earth Elemental Totem',

    ['SHAMAN_FEU_FIRENOVA'] = 'Fire Nova Totem',
    ['SHAMAN_FEU_SEARING'] = 'Searing Totem',
    ['SHAMAN_FEU_FROSTRESIST'] = 'Frost Resistance Totem',
    ['SHAMAN_FEU_MAGMA'] = 'Magma Totem',
    ['SHAMAN_FEU_FLAMETONGUE'] = 'Flametongue Totem',
    ['SHAMAN_FEU_FIREELEM'] = 'Fire Elemental Totem',
    ['SHAMAN_FEU_WRATH'] = 'Totem of Wrath',

    ['SHAMAN_EAU_POISONCLEAN'] = 'Poison Cleansing Totem',
    ['SHAMAN_EAU_MANASPRING'] = 'Mana Spring Totem',
    ['SHAMAN_EAU_FIRERESIST'] = 'Fire Resistance Totem',
    ['SHAMAN_EAU_HEALING'] = 'Healing Stream Totem',
    ['SHAMAN_EAU_DISEASECLEAN'] = 'Disease Cleansing Totem',
    ['SHAMAN_EAU_MANATIDE'] = 'Mana Tide Totem',
    ['SHAMAN_EAU_ENAMORED'] = 'Enamored Water Spirit',

    ['SHAMAN_AIR_GROUNDING'] = 'Grounding Totem',
    ['SHAMAN_AIR_NATURERESIST'] = 'Nature Resistance Totem',
    ['SHAMAN_AIR_WINDFURY'] = 'Windfury Totem',
    ['SHAMAN_AIR_SENTRY'] = 'Sentry Totem',
    ['SHAMAN_AIR_WINDWALL'] = 'Windwall Totem',
    ['SHAMAN_AIR_GRACE'] = 'Grace of Air Totem',
    ['SHAMAN_AIR_TRANQUIL'] = 'Tranquil Air Totem',
    ['SHAMAN_AIR_WRATHAIR'] = 'Wrath of Air Totem',

    ['SHAMAN_SHIELD_LIGHTING'] = 'Lightning Shield',
    ['SHAMAN_SHIELD_EARTH'] = 'Earth Shield',
    ['SHAMAN_SHIELD_WATER'] = 'Water Shield',

    ['SHAMAN_ANCESTRAL_SPIRIT'] = 'Ancestral Spirit',
    ['SHAMAN_REINCARNATION'] = 'Reincarnation',
    ['SHAMAN_PURGE'] = 'Purge',
    ['SHAMAN_CURE_POISON'] = 'Cure Poison',
    ['SHAMAN_CURE_DISEASE'] = 'Cure Disease',
    ['SHAMAN_WATER_BREATHING'] = 'Water Breathing',
    ['SHAMAN_WATER_WALKING'] = 'Water Walking',
    ['SHAMAN_FAR_SIGHT'] = 'Far Sight',
    ['SHAMAN_ASTRAL_RECALL'] = 'Astral Recall',
    ['SHAMAN_GHOST_WOLF'] = 'Ghost Wolf',
    ['SHAMAN_BLOODLUST'] = 'Bloodlust',
    ['SHAMAN_HEROISM'] = 'Heroism',
    ['SHAMAN_SHAMANRAGE'] = 'Shamanistic Rage',
    ['SHAMAN_ELEMMASTER'] = 'Elemental Mastery',
    ['SHAMAN_NATURESWIFT'] = 'Nature\'s Swiftness',
    ['SHAMAN_TAUREN'] = 'War Stomp',
    ['SHAMAN_ORC'] = 'Blood Fury',
    ['SHAMAN_TROLL'] = 'Berserking',
    ['SHAMAN_NAARU'] = 'Blessing of the Naaru',
    ['SHAMAN_TOTEMICCALL'] = 'Totemic Call',
    ['SHAMAN_STORMSTRIKE'] = 'Stormstrike',
}

-- startup/close functions

function Totemus:OnInitialize()
    self:TimersRegisterArrange({'Horizontal', 'Vertical', 'Box'});
    self:TimersRegisterAlign({'Left/Top', 'Right/Down'});
    self:TimersRegisterStyle({'Sticky', 'Element', 'Buff', 'Fixed'});

   self.options = { 
        type = 'group',
        args = {
            menu = {
                type = 'execute',
                name = 'Menu',
                desc = L['TOGGLE_CONFIG'],
                func = TotemusConfig_Toggle,
            },
            minimap = {
                type = 'execute',
                name = 'Minimap',
                desc = L['TOGGLE_MINIMAP'],
                func = Totemus_MinimapToggle,               
            }
        }
    }
    DEFAULT_CHAT_FRAME:AddMessage(L['WELCOME']);
    self:RegisterChatCommand(L['SLASH_COMMANDS'], self.options);
    
    self.dbDefaults = {
        sphereLocking = false, 
        sphereRotation = 36, -- rotation in degrees
        sphereScale = 100, -- scale in percent
        sphereStatusCircle = 0, -- show on sphere circle
        sphereStatusText = 0, -- show on sphere text
        sphereActionLeft = 0, -- left click one sphere
        sphereActionRight = 0, -- right click on sphere
        -- TotemusTimers 
        timersShow = true,
        timersLock = false,
        timersWarn = true,
        timersNotify = true,
        timersArrange = 1,
        timersAlign = 1,
        timersStyle = 1,
        -- menu behaviour 
        menuKeepOpen = false;
        menuCloseTimeout = 2;
        -- remember spells
        rememberEauMenu = {
            [0] = '',
            [1] = '',
        },
        rememberAirMenu = {
            [0] = '',
            [1] = '',
        },
        rememberFeuMenu = {
            [0] = '',
            [1] = '',
        },
        rememberTerreMenu = {
            [0] = '',
            [1] = '',
        },
        rememberBuffMenu = {
            [0] = '',
            [1] = '',
        },
        -- button
        buttonlocklast = false, -- lock remember totem
        buttonLocking = true, -- lock buttons to sphere
        buttonTooltips = true, -- tooltips on buttons and sphere?
        buttonDefaultTooltips = false; -- use default tooltip position
        buttonsUseGrid = true; --use a grid of 10px to align buttons
        -- buttons visible or not
        buttonDrinkVisible = true,
        buttonPotionVisible = true,
        buttonMountVisible = true,
        buttonAirMenuVisible = true,
        buttonEauMenuVisible = true,
        buttonFeuMenuVisible = true,
        buttonTerreMenuVisible = true,
        buttonBuffMenuVisible = true,
        buttonActionOneVisible = true,
        buttonActionTwoVisible = true,
        -- action button clicks
        buttonActionOneLeft = 0,
        buttonActionOneRight = 0,
        buttonActionTwoLeft = 0,
        buttonActionTwoRight = 0,
        -- messages
        messagesLanguage = 0,
        messagesOnScreen = true,
        messagesMissingTexture = false;
        messagesRaidMode = false,
        messagesRandom = false,
        messagesRandomAncestralSpirit = true,
        messagesRandomMount = true,
    };

    self:RegisterDB('TotemusDB', 'TotemusDBPC');
    self:RegisterDefaults('char', self.dbDefaults);

    self:InitPlayerInfos();
    -- Called when the addon is loaded
    self:ButtonSetup('Totemus', {'Potion', 'Drink', 'BuffMenu', 'ActionOne', 'ActionTwo', 'Mount', 'EauMenu', 'AirMenu', 'FeuMenu', 'TerreMenu'});
    self:RegisterSpells(TOTEMUS_SPELLS);
    self:ButtonRegisterActions({    
        { type = 'slot', data = 'Trinket0Slot' }, --First trinket slot
        { type = 'slot', data = 'Trinket1Slot' }, --Second trinket slot     
        { type = 'spell', data = 'SHAMAN_GHOST_WOLF' },
        { type = 'spell', data = 'SHAMAN_ANCESTRAL_SPIRIT' },
        { type = 'spell', data = 'SHAMAN_PURGE' },
        { type = 'spell', data = 'SHAMAN_CURE_POISON' },
        { type = 'spell', data = 'SHAMAN_CURE_DISEASE' },
        { type = 'spell', data = 'SHAMAN_WATER_BREATHING' },
        { type = 'spell', data = 'SHAMAN_WATER_WALKING' },      
        { type = 'spell', data = 'SHAMAN_FAR_SIGHT' },
        { type = 'spell', data = 'SHAMAN_TOTEMICCALL' }, 
        { type = 'spell', data = 'SHAMAN_SHIELD_LIGHTING' },
        { type = 'spell', data = 'SHAMAN_SHIELD_EARTH' },
        { type = 'spell', data = 'SHAMAN_SHIELD_WATER' },
        { type = 'spell', data = 'SHAMAN_STORMSTRIKE' }, 
        { type = 'spell', data = 'SHAMAN_SHAMANRAGE' }, 
        { type = 'spell', data = 'SHAMAN_ELEMMASTER' }, 
        { type = 'spell', data = 'SHAMAN_NATURESWIFT' }, 
        { type = 'spell', data = 'SHAMAN_BLOODLUST' }, 
        { type = 'spell', data = 'SHAMAN_HEROISM' }, 
        { type = 'spell', data = 'SHAMAN_TAUREN' }, 
        { type = 'spell', data = 'SHAMAN_ORC' }, 
        { type = 'spell', data = 'SHAMAN_TROLL' }, 
        { type = 'spell', data = 'SHAMAN_NAARU' }, 
    });
    self:SphereRegisterStatus(
        {'MANA', 'HEALTH', 'XP'},
        {'MANA', 'HEALTH', 'DRINK_FOOD', 'CD_REINC', 'SHIELD', 'SHIELDREINC'}
    );
    self:ButtonRegisterMenu('FeuMenu', {   
        { type = 'spell', data = 'SHAMAN_FEU_FIRENOVA' },
        { type = 'spell', data = 'SHAMAN_FEU_SEARING' },       
        { type = 'spell', data = 'SHAMAN_FEU_MAGMA' },      
        { type = 'spell', data = 'SHAMAN_FEU_FROSTRESIST' },    
        { type = 'spell', data = 'SHAMAN_FEU_FLAMETONGUE' },    
        { type = 'spell', data = 'SHAMAN_FEU_WRATH' },    
        { type = 'spell', data = 'SHAMAN_FEU_FIREELEM' },   
    });
    self:ButtonRegisterMenu('EauMenu', {
        { type = 'spell', data = 'SHAMAN_EAU_DISEASECLEAN' },    
        { type = 'spell', data = 'SHAMAN_EAU_POISONCLEAN'},
        { type = 'spell', data = 'SHAMAN_EAU_FIRERESIST' },   
        { type = 'spell', data = 'SHAMAN_EAU_HEALING' },      
        { type = 'spell', data = 'SHAMAN_EAU_MANASPRING' },    
        { type = 'spell', data = 'SHAMAN_EAU_MANATIDE' },   
        { type = 'spell', data = 'SHAMAN_EAU_ENAMORED' },   
    });
    self:ButtonRegisterMenu('AirMenu', {
        { type = 'spell', data = 'SHAMAN_AIR_WINDFURY' },   
        { type = 'spell', data = 'SHAMAN_AIR_GROUNDING' },
        { type = 'spell', data = 'SHAMAN_AIR_SENTRY' },   
        { type = 'spell', data = 'SHAMAN_AIR_WRATHAIR' },  
        { type = 'spell', data = 'SHAMAN_AIR_GRACE' },   
        { type = 'spell', data = 'SHAMAN_AIR_NATURERESIST' },   
        { type = 'spell', data = 'SHAMAN_AIR_TRANQUIL' },  
        { type = 'spell', data = 'SHAMAN_AIR_WINDWALL' }, 
    });
    self:ButtonRegisterMenu('TerreMenu', {
        { type = 'spell', data = 'SHAMAN_TERRE_EARTHBIND' },
        { type = 'spell', data = 'SHAMAN_TERRE_TREMOR' },
        { type = 'spell', data = 'SHAMAN_TERRE_EARTHELEM' },     
        { type = 'spell', data = 'SHAMAN_TERRE_STONECLAW' },
        { type = 'spell', data = 'SHAMAN_TERRE_STONESKIN' },    
        { type = 'spell', data = 'SHAMAN_TERRE_STRENGHEARTH' },
    });
    self:ButtonRegisterMenu('BuffMenu', {
        { type = 'spell', data = 'SHAMAN_BUFF_FLAME' },
        { type = 'spell', data = 'SHAMAN_BUFF_FROST' },     
        { type = 'spell', data = 'SHAMAN_BUFF_ROCK' },
        { type = 'spell', data = 'SHAMAN_BUFF_WIND' },    
    });
    self:RegisterSpeechLanguage('enUS', TOTEMUS_RANDOM_MESSAGES_enUS);
    self:RegisterSpeechLanguage('deDE', TOTEMUS_RANDOM_MESSAGES_deDE);
    self:RegisterSpeechLanguage('frFR', TOTEMUS_RANDOM_MESSAGES_frFR);
    self:RegisterSpeechLanguage('zhTW', TOTEMUS_RANDOM_MESSAGES_zhTW);
    
    metro:Register("TotemusTimer", self.OnTimerTick, 1, self);
end

function Totemus:OnEnable()
    -- starting up
    self:RegisterEvent('PLAYER_ENTERING_WORLD');
    -- new zone
    self:RegisterEvent('ZONE_CHANGED_NEW_AREA');
        
    -- monitor some status infos
    self:RegisterEvent('UNIT_HEALTH');
    self:RegisterEvent('UNIT_MANA');
    
    -- some basic info has changed
    self:RegisterEvent('SPELLS_CHANGED');
    self:RegisterEvent('BAG_UPDATE');
    
    self:RegisterEvent('UNIT_SPELLCAST_SENT'); -- capture spellcasts (messages, recasts)
    self:RegisterEvent('UNIT_SPELLCAST_STOP');
    self:RegisterEvent('UNIT_SPELLCAST_FAILED'); 
    self:RegisterEvent('UNIT_SPELLCAST_INTERRUPTED'); 
    self:RegisterEvent('UNIT_SPELLCAST_SUCCEEDED');    
    
    
    -- start the update timer
    metro:Start("TotemusTimer");
end

-- timer ticks
function Totemus:OnTimerTick()
    self:UpdateStatus();
end

-- event callbacks
function Totemus:PLAYER_ENTERING_WORLD()
    self:InitPlayerInfos();
    self:MountZoneInformation();
    self:UpdateSpellTable();
    self:InventoryScan();
    self:UpdateActions();
    self:UpdateStatus();
    self:BindingLoad();
end

function Totemus:SPELLS_CHANGED()
    self:UpdateSpellTable();
    self:UpdateActions();
    self:UpdateStatus();
end

function Totemus:BAG_UPDATE()
    self:InventoryScan();
    self:UpdateActions();
    self:UpdateStatus();
end

function Totemus:ZONE_CHANGED_NEW_AREA()
    self:MountZoneInformation();
    self:UpdateActions();
end

function Totemus:UNIT_SPELLCAST_SENT(unitId, spell, rank, target)
    if unitId == 'player' then
        self.lastSpell = {
            ['spell'] = spell,
            ['rank'] = rank,
            ['target'] = target
        }
    end
end

function Totemus:UNIT_SPELLCAST_STOP(unitId)
    if unitId == 'player' then
        self.lastSpell = nil;
        if self.lastSpell ~= nil then
            self:OnSpellCast(self.lastSpell.spell, self.lastSpell.rank, self.lastSpell.target);
            self.lastSpell = nil;
        end
    end
end

function Totemus:UNIT_SPELLCAST_FAILED(unitId)
    if unitId == 'player' then
        self.lastSpell = nil;
        if self.lastSpell ~= nil then
            self.lastSpell = nil;
        end
    end
end

function Totemus:UNIT_SPELLCAST_INTERRUPTED(unitId)
    if unitId == 'player' then
        self.lastSpell = nil;
    end
end

function Totemus:UNIT_SPELLCAST_SUCCEEDED(unitId, spell, rank)
    if unitId == 'player' then
        if self.lastSpell ~= nil then
            if self.lastSpell ~= nil and spell == self.lastSpell.spell then
                self:OnSpellCast(spell, rank, self.lastSpell.target);
            end
            self.lastSpell = nil;
        end
    end
end

-- status update events
function Totemus:UNIT_HEALTH()
    self:UpdateStatus();
end
function Totemus:UNIT_MANA()
    self:UpdateStatus();
end

-- tooltip functions

function Totemus:ShowTooltip(element, buttonId, anchor)
    if not self.db.char.buttonTooltips then
        return
    end
  
    if self.db.char.buttonDefaultTooltips then
        GameTooltip_SetDefaultAnchor(GameTooltip, element);    
    else
        GameTooltip:SetOwner(element, anchor);
    end
  
    if buttonId == 'MAIN' then    
		GameTooltip:AddLine('Totemus');
        local itemCount, itemName = self:InventoryGetItemData('ANKH');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
        local itemCount, itemName = self:InventoryGetItemData('SCALE');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
        local itemCount, itemName = self:InventoryGetItemData('OIL');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
        local itemCount, itemName = self:InventoryGetItemData('DRINK');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
        local itemCount, itemName = self:InventoryGetItemData('FOOD');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
        local itemCount, itemName = self:InventoryGetItemData('POTION_MP');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end
        local itemCount, itemName = self:InventoryGetItemData('POTION_HP');
        if itemName ~= nil and itemCount ~= nil then
            GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        end        
        local _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.char.sphereActionLeft);
        local _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.char.sphereActionRight);  
        if actionLeftName then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
            if actionLeftTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionLeftName, actionLeftTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionLeftName, 0.8, 0.8, 0.1);
            end
            if actionLeftCooldown and actionLeftCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionLeftCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
        if actionRightName then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            if actionRightTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionRightName, actionRightTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionRightName, 0.8, 0.8, 0.1);
            end
            if actionRightCooldown and actionRightCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionRightCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
    elseif buttonId == 'DRINK' then
		GameTooltip:AddLine(L['TOOLTIP_DRINKFOOD']);
        self:TooltipAddItemData(GameTooltip, 'LeftButton', 'DRINK');
        self:TooltipAddItemData(GameTooltip, 'RightButton', 'FOOD');
    elseif buttonId == 'POTION' then
		GameTooltip:AddLine(L['TOOLTIP_POTION']);
        self:TooltipAddItemData(GameTooltip, 'LeftButton', 'POTION_HP');
        self:TooltipAddItemData(GameTooltip, 'RightButton', 'POTION_MP');
    elseif buttonId == 'MOUNT' then
        local _, _, itemName = self:InventoryGetMountData();
        if itemName ~= nil then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
            GameTooltip:AddLine(itemName, 0.8, 0.8, 0.1);
        end
     if self.spellTable['SHAMAN_ASTRAL_RECALL'].index == 0 then
        local _, itemName, _, _, cooldown = self:InventoryGetItemData('HEARTHSTONE');
        if itemName ~= nil then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            GameTooltip:AddLine(itemName..' ('..GetBindLocation()..')', 0.8, 0.8, 0.1);
            if cooldown and cooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
      else local spellIdd = self.spellTable['SHAMAN_ASTRAL_RECALL'];
             local start2, duration2 = GetSpellCooldown(spellIdd.index, BOOKTYPE_SPELL);
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            GameTooltip:AddLine(GetSpellName(spellIdd.index, BOOKTYPE_SPELL)..' ('..GetBindLocation()..')', 0.8, 0.8, 0.1);
            if ( start2 > 0 and duration2 > 0) then
                       cooldownTime = ( math.floor(duration2 - ( GetTime() - start2)) )
	     if cooldownTime >= 3600 then
                            cooldownString = math.floor((cooldownTime / 3600) + 0.5);
                            timeUnit = 'h';
                      elseif cooldownTime >= 60 then
                            cooldownString = math.floor((cooldownTime / 60) + 0.5);
                            timeUnit = 'm';
                      else
                            cooldownString = math.floor(cooldownTime + 0.5);
                            timeUnit = 's';    
                      end
                  GameTooltip:AddLine((cooldownString)..timeUnit, 0.7, 0.7, 0.7);
               end
      end
    elseif buttonId == 'ACTION_ONE' or buttonId == 'ACTION_TWO' then
        local actionLeftName, actionLeftTooltip, actionLeftCooldown;
        local actionRightName, actionRightTooltip, actionRightCooldown;
        if buttonId == 'ACTION_ONE' then
            _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.char.buttonActionOneLeft);
            _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.char.buttonActionOneRight);
        elseif buttonId == 'ACTION_TWO' then
            _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:ButtonGetActionInfo(self.db.char.buttonActionTwoLeft);
            _, actionRightName, _, actionRightTooltip, actionRightCooldown = self:ButtonGetActionInfo(self.db.char.buttonActionTwoRight); 
        end
        if actionLeftName then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
            if actionLeftTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionLeftName, actionLeftTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionLeftName, 0.8, 0.8, 0.1);
            end
            if actionLeftCooldown and actionLeftCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionLeftCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
        if actionRightName then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
            if actionRightTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionRightName, actionRightTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionRightName, 0.8, 0.8, 0.1);
            end
            if actionRightCooldown and actionRightCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionRightCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
        end
    elseif buttonId == 'ATTRIBUTES' then
        local buttonType = element:GetAttribute('*type*');
        if buttonType ~= nil then
            local buttonAction = element:GetAttribute('*'..buttonType..'*');
            if buttonType == 'spell' then
                -- spell name to totemus spell id
                if self.spellTableRevIndex ~= nil and self.spellTableRevIndex[buttonAction] ~= nil then
                    -- totemus spell id to spell data
                    local spellData = self.spellTable[self.spellTableRevIndex[buttonAction]];
                    -- check data and set tooltip
                    if spellData ~= nil and spellData.index ~= nil and spellData.index > 0 then
                        GameTooltip:SetSpell(spellData.index, BOOKTYPE_SPELL);
                    end
                end
            end
        end
    elseif buttonId == 'AIRMENU' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'AirMenu');
    elseif  buttonId == 'EAUMENU' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'EauMenu');
    elseif  buttonId == 'FEUMENU' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'FeuMenu');
    elseif  buttonId == 'TERREMENU' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'TerreMenu');
    elseif  buttonId == 'BUFFMENU' then
        GameTooltip:AddLine(L['BUTTON_'..buttonId]);
        self:TooltipAddMenuSpellData(tooltip, 'BuffMenu');
    end
  
	-- and done, show it!
	GameTooltip:Show();
end

function Totemus:TooltipAddItemData(tooltip, button, itemGroup)
    local itemCount, itemName, _, _, cooldown = self:InventoryGetItemData(itemGroup);
    if itemName ~= nil then
        if button == 'LeftButton' then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
        elseif button == 'RightButton' then
            GameTooltip:AddLine(L['TOOLTIP_RIGHTCLICK'], 1.0, 1.0, 1.0);
        end
        GameTooltip:AddDoubleLine(itemName..': ', itemCount, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);
        if cooldown and cooldown > 0 then
            local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldown);
            GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
        end
    end
end

function Totemus:TooltipAddMenuSpellData(tooltip, menuId)
    local optionName = 'remember'..menuId;
    if self.db.char[optionName] ~= nil then
        local _, actionLeftName, _, actionLeftTooltip, actionLeftCooldown = self:GetActionInfo('spell', self.db.char[optionName][0]);
        if actionLeftName then
            GameTooltip:AddLine(L['TOOLTIP_LEFTCLICK'], 1.0, 1.0, 1.0);
            if actionLeftTooltip ~= nil then
                GameTooltip:AddDoubleLine(actionLeftName, actionLeftTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
            else
                GameTooltip:AddLine(actionLeftName, 0.8, 0.8, 0.1);
            end
            if actionLeftCooldown and actionLeftCooldown > 0 then
                local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionLeftCooldown);
                GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
            end
            local _, actionMiddleName, _, actionMiddleTooltip, actionMiddleCooldown = self:GetActionInfo('spell', self.db.char[optionName][1]);
            if actionMiddleName then
                GameTooltip:AddLine(L['TOOLTIP_MIDDLECLICK'], 1.0, 1.0, 1.0);
                if actionMiddleTooltip ~= nil then
                    GameTooltip:AddDoubleLine(actionMiddleName, actionMiddleTooltip, 0.8, 0.8, 0.1, 1.0, 1.0, 1.0);            
                else
                    GameTooltip:AddLine(actionMiddleName, 0.8, 0.8, 0.1);
                end
                if actionMiddleCooldown and actionMiddleCooldown > 0 then
                    local cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionMiddleCooldown);
                    GameTooltip:AddLine(self:GetTooltipCooldownStr(cooldownString, cooldownUnit), 0.7, 0.7, 0.7);
                end                
            end   
        end
    end
end

function Totemus:UpdateStatus()
    if (not InCombatLockdown()) and self.updatePending then
        self:UpdateActions();
    end

    self:BindingLoad()
    local reincId, start, duration, cooldownString, timeUnit, cooldownTime;
    local circleInfo, textInfo = self:SphereGetStatusInfo(self.db.char.sphereStatusCircle, self.db.char.sphereStatusText);
    -- update circle
    if self.db.char.sphereStatusCircle == nil or self.db.char.sphereStatusCircle == 0 then
        self:SphereSetStatusValues(0, nil);        
    elseif circleInfo ~= nil then
        local statusCircle = 0;
        local hasPet = HasPetUI();
        if circleInfo == 'MANA' then
            statusCircle = math.floor((UnitMana('player') * 16 / UnitManaMax('player')) + 0.5);
        elseif circleInfo == 'HEALTH' then
            statusCircle = math.floor((UnitHealth('player') * 16 / UnitHealthMax('player')) + 0.5);
        elseif circleInfo == 'XP' then
            statusCircle = math.floor((UnitXP('player') * 16 / UnitXPMax('player')) + 0.5);
        end        
        self:SphereSetStatusValues(statusCircle, nil);
    end
    -- update sphere text
    if self.db.char.sphereStatusText == nil or self.db.char.sphereStatusText == 0 then
        self:SphereSetStatusValues(nil, '');        
    elseif textInfo ~= nil then
        local statusText = '';
        local hasPet = HasPetUI();
        if textInfo == 'MANA' then
            statusText = (math.floor((UnitMana('player') * 100 / UnitManaMax('player')) + 0.5))..'%\n'..UnitMana('player');
        elseif textInfo == 'HEALTH' then
            statusText = (math.floor((UnitHealth('player') * 100 / UnitHealthMax('player')) + 0.5))..'%\n'..UnitHealth('player');
        elseif textInfo == 'SHIELD' then
              shield_light = GetPlayerBuffApplications(TOTEMUS_SHIELD_LIGHT);
              shield_water = GetPlayerBuffApplications(TOTEMUS_SHIELD_WATER);
              shield_earth = GetPlayerBuffApplications(TOTEMUS_SHIELD_EARTH);
              if (shield_light ~= 0) then
                  statusText = shield_light
              elseif (shield_water ~= 0) then
                  statusText = shield_water
              elseif (shield_earth ~= 0) then
                  statusText = shield_earth
              else statusText = "/"
              end
        elseif textInfo == 'SHIELDREINC' then
            if self.spellTable['SHAMAN_REINCARNATION'].index ~= 0 then
            reincId = self.spellTable['SHAMAN_REINCARNATION'];
            start, duration = GetSpellCooldown(reincId.index, BOOKTYPE_SPELL);
                  if ( start > 0 and duration > 0) then
                       cooldownTime = ( math.floor(duration - ( GetTime() - start)) )
	     if cooldownTime >= 3600 then
                            cooldownString = math.floor((cooldownTime / 3600) + 0.5);
                            timeUnit = 'h';
                      elseif cooldownTime >= 60 then
                            cooldownString = math.floor((cooldownTime / 60) + 0.5);
                            timeUnit = 'm';
                      else
                            cooldownString = math.floor(cooldownTime + 0.5);
                            timeUnit = 's';    
                      end
                 end
                     if cooldownString then
                         statusText = (cooldownString)..timeUnit;
                     else 
                         shield_light = GetPlayerBuffApplications(TOTEMUS_SHIELD_LIGHT);
                         shield_water = GetPlayerBuffApplications(TOTEMUS_SHIELD_WATER);
                         shield_earth = GetPlayerBuffApplications(TOTEMUS_SHIELD_EARTH);
                         if (shield_light ~= 0) then
                            statusText = shield_light
                         elseif (shield_water ~= 0) then
                            statusText = shield_water
                         elseif (shield_earth ~= 0) then
                            statusText = shield_earth
                         else statusText = "/"
                         end   
                      end        
               else
	statusText = (' ');
             end
        elseif textInfo == 'CD_REINC' then
            if self.spellTable['SHAMAN_REINCARNATION'].index ~= 0 then
            reincId = self.spellTable['SHAMAN_REINCARNATION'];
            start, duration = GetSpellCooldown(reincId.index, BOOKTYPE_SPELL);
                  if ( start > 0 and duration > 0) then
                       cooldownTime = ( math.floor(duration - ( GetTime() - start)) )
	     if cooldownTime >= 3600 then
                            cooldownString = math.floor((cooldownTime / 3600) + 0.5);
                            timeUnit = 'h';
                      elseif cooldownTime >= 60 then
                            cooldownString = math.floor((cooldownTime / 60) + 0.5);
                            timeUnit = 'm';
                      else
                            cooldownString = math.floor(cooldownTime + 0.5);
                            timeUnit = 's';    
                      end
                  statusText = (cooldownString)..timeUnit;
               else
	statusText = (' ');
               end
             end
        elseif textInfo == 'DRINK_FOOD' then
            local itemDrinkCount = self:InventoryGetItemData('DRINK');
            local itemFoodCount = self:InventoryGetItemData('FOOD'); 
            if itemDrinkCount ~= nil then
                statusText = itemDrinkCount..'/';
            else
                statusText = '0/';
            end
            if itemFoodCount ~= nil then
                statusText = statusText..itemFoodCount;
            else
                statusText = statusText..'0';
            end
        end
        self:SphereSetStatusValues(nil, statusText);
    end
    -- update potion cooldown
    local _, _, _, _, cooldownHP = self:InventoryGetItemData('POTION_HP');
    local _, _, _, _, cooldownMP = self:InventoryGetItemData('POTION_MP');
    local cooldownString = nil;
    local cooldownUnit = nil;
    if cooldownHP ~= nil and cooldownHP > 0 then
        cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldownHP);
    elseif cooldownMP ~= nil and cooldownMP > 0 then
        cooldownString, cooldownUnit = self:GetFormattedCooldownTime(cooldownMP);
    end
    if cooldownString then
        self:ButtonSetCaption('Potion', self:GetButtonCooldownStr(cooldownString, cooldownUnit));
        self:ButtonSetStatus('Potion', false);        
    else
        self:ButtonSetCaption('Potion', nil);
        self:ButtonSetStatus('Potion', true);
    end
    
    local currentMana = UnitMana('player');
    
    -- action buttons
    self:UpdateActionButtonStatus('ActionOne', currentMana);
    self:UpdateActionButtonStatus('ActionTwo', currentMana);

    local actionName = nil;
    local actionCooldown = nil;
    local actionMana = nil;
    if self.buttons ~= nil and self.buttons.menus ~= nil and self.buttons.menus['TerreMenu'] ~= nil then
            if actionName == nil then
                _, actionName, _, _, actionCooldown, actionMana = self:GetActionInfo('spell', self.db.char['rememberTerreMenu'][0]);   
            end
    end
    if actionName ~= nil then
        if actionCooldown ~= nil and actionCooldown > 0 then
            cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionCooldown);
            if cooldownString then
                self:ButtonSetCaption('TerreMenu', self:GetButtonCooldownStr(cooldownString, cooldownUnit));
                self:ButtonSetStatus('TerreMenu', false); 
            else
                self:ButtonSetCaption('TerreMenu', ''); 
                self:ButtonSetStatus('TerreMenu', true); 
            end 
        else
            self:ButtonSetCaption('TerreMenu', ''); 
            self:ButtonSetStatus('TerreMenu', true);         
        end
    else
        self:ButtonSetStatus('TerreMenu', false);     
    end    
    local actionName2 = nil;
    local actionCooldown2 = nil;
    local actionMana2 = nil;
    if self.buttons ~= nil and self.buttons.menus ~= nil and self.buttons.menus['FeuMenu'] ~= nil then
            if actionName2 == nil then
                _, actionName2, _, _, actionCooldown2, actionMana2 = self:GetActionInfo('spell', self.db.char['rememberFeuMenu'][0]);   
            end
    end
    if actionName2 ~= nil then
        if actionCooldown2 ~= nil and actionCooldown2 > 0 then
            cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionCooldown2);
            if cooldownString then
                self:ButtonSetCaption('FeuMenu', self:GetButtonCooldownStr(cooldownString, cooldownUnit));
                self:ButtonSetStatus('FeuMenu', false); 
            else
                self:ButtonSetCaption('FeuMenu', ''); 
                self:ButtonSetStatus('FeuMenu', true); 
            end 
        else
            self:ButtonSetCaption('FeuMenu', ''); 
            self:ButtonSetStatus('FeuMenu', true);         
        end
    else
        self:ButtonSetStatus('FeuMenu', false);     
    end    
    local actionName3 = nil;
    local actionCooldown3 = nil;
    local actionMana3 = nil;
    if self.buttons ~= nil and self.buttons.menus ~= nil and self.buttons.menus['AirMenu'] ~= nil then
            if actionName3 == nil then
                _, actionName3, _, _, actionCooldown3, actionMana3 = self:GetActionInfo('spell', self.db.char['rememberAirMenu'][0]);   
            end
    end
    if actionName3 ~= nil then
        if actionCooldown3 ~= nil and actionCooldown3 > 0 then
            cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionCooldown3);
            if cooldownString then
                self:ButtonSetCaption('AirMenu', self:GetButtonCooldownStr(cooldownString, cooldownUnit));
                self:ButtonSetStatus('AirMenu', false); 
            else
                self:ButtonSetCaption('AirMenu', ''); 
                self:ButtonSetStatus('AirMenu', true); 
            end 
        else
            self:ButtonSetCaption('AirMenu', ''); 
            self:ButtonSetStatus('AirMenu', true);         
        end
    else
        self:ButtonSetStatus('AirMenu', false);     
    end    
    local actionName4 = nil;
    local actionCooldown4 = nil;
    local actionMana4 = nil;
    if self.buttons ~= nil and self.buttons.menus ~= nil and self.buttons.menus['EauMenu'] ~= nil then
            if actionName4 == nil then
                _, actionName4, _, _, actionCooldown4, actionMana4 = self:GetActionInfo('spell', self.db.char['rememberEauMenu'][0]);   
            end
    end
    if actionName4 ~= nil then
        if actionCooldown4 ~= nil and actionCooldown4 > 0 then
            cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionCooldown4);
            if cooldownString then
                self:ButtonSetCaption('EauMenu', self:GetButtonCooldownStr(cooldownString, cooldownUnit));
                self:ButtonSetStatus('EauMenu', false); 
            else
                self:ButtonSetCaption('EauMenu', ''); 
                self:ButtonSetStatus('EauMenu', true); 
            end 
        else
            self:ButtonSetCaption('EauMenu', ''); 
            self:ButtonSetStatus('EauMenu', true);         
        end
    else
        self:ButtonSetStatus('EauMenu', false);     
    end
    -- mount button highlighting
    if IsMounted() then
        TotemusButtonMount:LockHighlight();
    else
        TotemusButtonMount:UnlockHighlight();    
        local mountName = self:InventoryGetMountData();        
        if mountName ~= nil and (not mountName == TotemusButtonMount:GetAttribute('item1')) then
            self:UpdateActions();
        end
    end
    
    -- update button status (mana depending spells)
    self:ButtonUpdateMenuStatus();
end

function Totemus:UpdateActionButtonStatus(buttonId, currentMana)
    local _, actionName, _, _, actionCooldown, actionMana = self:ButtonGetActionInfo(self.db.char['button'..buttonId..'Left']);
    if actionName == nil then
        _, actionName, _, _, actionCooldown, actionMana = self:ButtonGetActionInfo(self.db.char['button'..buttonId..'Right']);        
    end
    local buttonEnabled = true;
    if actionName ~= nil then
        if  actionCooldown ~= nil and actionCooldown > 0 then
            cooldownString, cooldownUnit = self:GetFormattedCooldownTime(actionCooldown);
            if cooldownString then
                self:ButtonSetCaption(buttonId, self:GetButtonCooldownStr(cooldownString, cooldownUnit));
                buttonEnabled = false;
            else
                self:ButtonSetCaption(buttonId, '');        
            end
        else 
            self:ButtonSetCaption(buttonId, '');
        end
        if actionMana ~= nil and actionMana > 0 and actionMana > currentMana then
            buttonEnabled = false;        
        end
    else
        buttonEnabled = false;
    end
    if buttonEnabled then 
        self:ButtonSetStatus(buttonId, true);     
    else
        self:ButtonSetStatus(buttonId, false);      
    end
end

function Totemus:UpdateActions()
    if InCombatLockdown() then
        self.updatePending = true;
        return;
    end
    if self.updatePending then
        self:UpdateTemporaryOptions();
    end
    
    -- sphere    
    actionType, actionName = self:ButtonGetActionInfo(self.db.char.sphereActionLeft);     
    if actionType ~= nil and actionName then
        if actionType == 'spell' then
            self:SphereSetSpell('LeftButton', actionName);
        else
            self:SphereSetItem('LeftButton',actionName);
        end
    else 
        self:SphereSetSpell('LeftButton', '');
    end
    actionType, actionName = self:ButtonGetActionInfo(self.db.char.sphereActionRight);    
    if actionType ~= nil and actionName then
        if actionType == 'spell' then
            self:SphereSetSpell('RightButton', actionName);
        else
            self:SphereSetItem('RightButton', actionName);
        end
    else 
        self:SphereSetSpell('RightButton', '');
    end 
    
    -- drink button
    self:UpdateItemButton('Drink', 'DRINK', 'FOOD', 'Spell_Misc_Drink');    
    -- potions button
    self:UpdateItemButton('Potion', 'POTION_HP', 'POTION_MP', 'INV_Potion_90');
    
    -- mount button
    local itemMountName, itemMountTexture = self:InventoryGetMountData();
    local _, itemHearthStoneName, itemHearthStoneTexture = self:InventoryGetItemData('HEARTHSTONE');
    local recallId = self.spellTable['SHAMAN_ASTRAL_RECALL'];
    if itemMountName ~= nil then        
	self:ButtonSetStatus('Mount', true);
	self:ButtonSetIcon('Mount', itemMountTexture);
	self:ButtonSetItem('Mount', 'LeftButton', itemMountName);
	if recallId.index == 0 then
		if itemHearthStoneName ~= nil then
			self:ButtonSetItem('Mount', 'RightButton', itemHearthStoneName);
		else 
			self:ButtonSetItem('Mount', 'RightButton', '');        
		end
	else
		local recallName = GetSpellName(recallId.index, BOOKTYPE_SPELL);
		self:ButtonSetSpell('Mount', 'RightButton', recallName);
	end
   else     
	self:ButtonSetItem('Mount', 'LeftButton', '');
	if recallId.index == 0 then
		if itemHearthStoneName ~= nil then
			self:ButtonSetIcon('Mount', itemHearthStoneTexture);
			self:ButtonSetItem('Mount', 'RightButton', itemHearthStoneName);
		else 
			self:ButtonSetIcon('Mount', 'INV_Misc_Rune_01');
			self:ButtonSetItem('Mount', 'RightButton', '');        
		end
	else 
    		local recallName = GetSpellName(recallId.index, BOOKTYPE_SPELL);
		self:ButtonSetIcon('Mount', 'Spell_Nature_AstralRecal');
		self:ButtonSetSpell('Mount', 'RightButton', recallName);
	end
   end
       
    -- action button one
    self:UpdateActionButton('ActionOne');
    self:UpdateActionButton('ActionTwo');
    
    -- action button three
    self:ButtonUpdateMenus();
    -- set remembered spells and show icon for right click
    self:UpdateMenuButtonSpells('FeuMenu', 'Spell_Fire_SelfDestruct');
    self:UpdateMenuButtonSpells('EauMenu', 'Spell_Frost_SummonWaterElemental');
    self:UpdateMenuButtonSpells('TerreMenu', 'Spell_Nature_StrengthOfEarthTotem02');
    self:UpdateMenuButtonSpells('AirMenu', 'Spell_Nature_EarthBind'); 
    self:UpdateMenuButtonSpells('BuffMenu', 'Spell_Nature_RockBiter'); 


    self.updatePending = false;
end

function Totemus:UpdateMenuButtonSpells(menuId, defaultTexture)
    local optionName = 'remember'..menuId;
    if self.db.char[optionName] ~= nil then
        local actionTypeLeft, actionNameLeft, actionTextureLeft = self:GetActionInfo('spell', self.db.char[optionName][0]);
        if actionTypeLeft ~= nil and actionTypeLeft == 'spell' and actionNameLeft ~= nil then
            self:ButtonSetSpell(menuId, 'LeftButton', actionNameLeft);
            if self.db.char[optionName][0] ~= self.db.char[optionName][1] then
                local actionTypeMiddle, actionNameMiddle = self:GetActionInfo('spell', self.db.char[optionName][1]);
                if actionTypeMiddle ~= nil and actionTypeMiddle == 'spell' and actionNameMiddle ~= nil then
                    self:ButtonSetSpell(menuId, 'MiddleButton', actionNameMiddle);
                else 
                    self:ButtonSetSpell(menuId, 'MiddleButton', '');        
                end
            else
                self:ButtonSetSpell(menuId, 'MiddleButton', '');           
            end
        else 
            self:ButtonSetSpell(menuId, 'LeftButton', ''); 
            self:ButtonSetSpell(menuId, 'MiddleButton', '');           
        end
        if actionTextureLeft then
            self:ButtonSetIcon(menuId, actionTextureLeft);
        else 
            self:ButtonSetIcon(menuId, defaultTexture);        
        end
    end
end

function Totemus:UpdateItemButton(buttonId, groupIdLeft, groupIdRight, defaultTexture)
    local _, itemLeftName, itemLeftTexture  = self:InventoryGetItemData(groupIdLeft);
    local _, itemRightName, itemRightTexture  = self:InventoryGetItemData(groupIdRight);
    if itemLeftName ~= nil then
        self:ButtonSetStatus(buttonId, true);
        self:ButtonSetIcon(buttonId, itemLeftTexture);
        self:ButtonSetItem(buttonId, 'LeftButton', itemLeftName);
        if itemRightName ~= nil then
            self:ButtonSetItem(buttonId, 'RightButton', itemRightName);
        else
            self:ButtonSetItem(buttonId, 'RightButton', '');        
        end
    else
        self:ButtonSetItem(buttonId, 'LeftButton', '');
        if itemRightName ~= nil then
            self:ButtonSetStatus(buttonId, true);
            self:ButtonSetIcon(buttonId, itemRightTexture);
            self:ButtonSetItem(buttonId, 'RightButton', itemRightName);
        else
            self:ButtonSetStatus(buttonId, false);
            self:ButtonSetIcon(buttonId, defaultTexture);
            self:ButtonSetItem(buttonId, 'RightButton', '');   
        end
    end
end

function Totemus:UpdateActionButton(buttonId)
    local actionLeftType, actionLeftName, actionLeftTexture = self:ButtonGetActionInfo(self.db.char['button'..buttonId..'Left']);
    local actionRightType, actionRightName, actionRightTexture = self:ButtonGetActionInfo(self.db.char['button'..buttonId..'Right']);
    if actionLeftType ~= nil and actionLeftName ~= nil then
        if actionLeftType == 'spell' then
            self:ButtonSetSpell(buttonId, 'LeftButton', actionLeftName);
        else 
            self:ButtonSetItem(buttonId, 'LeftButton', actionLeftName);        
        end
    else
        self:ButtonSetSpell(buttonId, 'LeftButton', '');    
    end
    if actionRightType ~= nil and actionRightName then
        if actionRightType == 'spell' then
            self:ButtonSetSpell(buttonId, 'RightButton', actionRightName);
        else 
            self:ButtonSetItem(buttonId, 'RightButton', actionRightName);        
        end
    else
        self:ButtonSetSpell(buttonId, 'RightButton', '');    
    end
    if actionLeftTexture ~= nil then
        self:ButtonSetIcon(buttonId, actionLeftTexture);
    elseif actionRightTexture ~= nil then
        self:ButtonSetIcon(buttonId, actionRightTexture);
    else 
        self:ButtonSetIcon(buttonId, 'DEFAULT');    
    end
end

function Totemus:BindingTotem(key, spell)
    key1, key2 = GetBindingKey(key);
    if spell and key1 then
       SetOverrideBindingSpell(this, true, key1, spell);
    end
    if spell and key2 then
       SetOverrideBindingSpell(this, true, key2, spell);
    end
end

function Totemus:BindingInit(spelli, keyi)
local totemId=self.spellTable[spelli];
if totemId then
local totemName = GetSpellName(totemId.index, BOOKTYPE_SPELL);
self:BindingTotem(keyi, totemName);
end
end

function Totemus:BindingLoad()
if self.db.char.rememberTerreMenu[0]then
self:BindingInit(self.db.char.rememberTerreMenu[0], "TOTEMUSTERRE1");
end
if self.db.char.rememberTerreMenu[1]then
self:BindingInit(self.db.char.rememberTerreMenu[1], "TOTEMUSTERRE2")
end
if self.db.char.rememberFeuMenu[0]then
self:BindingInit(self.db.char.rememberFeuMenu[0], "TOTEMUSFEU1")
end
if self.db.char.rememberFeuMenu[1]then
self:BindingInit(self.db.char.rememberFeuMenu[1], "TOTEMUSFEU2")
end
if self.db.char.rememberEauMenu[0]then
self:BindingInit(self.db.char.rememberEauMenu[0], "TOTEMUSEAU1")
end
if self.db.char.rememberEauMenu[1]then
self:BindingInit(self.db.char.rememberEauMenu[1], "TOTEMUSEAU2")
end
if self.db.char.rememberAirMenu[0]then
self:BindingInit(self.db.char.rememberAirMenu[0], "TOTEMUSAIR1")
end
if self.db.char.rememberAirMenu[1]then
self:BindingInit(self.db.char.rememberAirMenu[1], "TOTEMUSAIR2")
end
end

function Totemus:OnSpellCast(spell, rank, target)
    if spell ~= nil and self.spellTableRevIndex ~= nil then
        if target == nil then
            target = '';
        end
        local spellId = self.spellTableRevIndex[spell];        
        -- remember totems of terre, eau, feu, air
        if spellId == 'SHAMAN_TERRE_EARTHBIND' or spellId == 'SHAMAN_TERRE_STONECLAW' or spellId == 'SHAMAN_TERRE_STRENGHEARTH' or spellId == 'SHAMAN_TERRE_STONESKIN' 
            or spellId == 'SHAMAN_TERRE_TREMOR' or spellId == 'SHAMAN_TERRE_EARTHELEM' then
            -- remember last terre
            if self.db.char.buttonlocklast == false then
            self:ButtonRememberSpell('TerreMenu', spellId);
            end           
        elseif spellId == 'SHAMAN_EAU_POISONCLEAN' or spellId == 'SHAMAN_EAU_MANASPRING' or spellId == 'SHAMAN_EAU_FIRERESIST' or spellId == 'SHAMAN_EAU_HEALING' 
            or spellId == 'SHAMAN_EAU_DISEASECLEAN' or spellId == 'SHAMAN_EAU_MANATIDE' then
            -- remember last eau
            if self.db.char.buttonlocklast == false then
            self:ButtonRememberSpell('EauMenu', spellId);
            end            
        elseif spellId == 'SHAMAN_FEU_FIRENOVA' or spellId == 'SHAMAN_FEU_SEARING' or spellId == 'SHAMAN_FEU_FROSTRESIST' or spellId == 'SHAMAN_FEU_MAGMA' 
            or spellId == 'SHAMAN_FEU_FLAMETONGUE' or spellId == 'SHAMAN_FEU_FIREELEM' or spellId == 'SHAMAN_FEU_WRATH' then
            -- remember last feu
            if self.db.char.buttonlocklast == false then
            self:ButtonRememberSpell('FeuMenu', spellId);
            end 
        elseif spellId == 'SHAMAN_AIR_GROUNDING' or spellId == 'SHAMAN_AIR_NATURERESIST' or spellId == 'SHAMAN_AIR_WINDFURY' or spellId == 'SHAMAN_AIR_SENTRY' 
            or spellId == 'SHAMAN_AIR_WINDWALL' or spellId == 'SHAMAN_AIR_GRACE' or spellId == 'SHAMAN_AIR_WRATHAIR' or spellId == 'SHAMAN_AIR_TRANQUIL' then
            -- remember last Air
            if self.db.char.buttonlocklast == false then
            self:ButtonRememberSpell('AirMenu', spellId);
            end 
        elseif spellId == 'SHAMAN_BUFF_ROCK' or spellId == 'SHAMAN_BUFF_FLAME' or spellId == 'SHAMAN_BUFF_FROST' or spellId == 'SHAMAN_BUFF_WIND'  then
            -- remember last Buff
            if self.db.char.buttonlocklast == false then
            self:ButtonRememberSpell('BuffMenu', spellId);
            end 
        else 
            local inGroup = GetNumPartyMembers() > 0;
            if self.db.char.messagesRaidMode then
                if inGroup then
                    if spellId ~= nil and spellId == 'SHAMAN_ANCESTRAL_SPIRIT' then
                        self:DoSpeech('SAY', 'SHAMAN_ANCESTRAL_SPIRIT', nil, target);          
                    end
               end
            elseif self.db.char.messagesRandom then
                if spellId ~= nil and  spellId == 'SHAMAN_ANCESTRAL_SPIRIT' and self.db.char.messagesRandomAncestralSpirit then
                    self:DoSpeech('SAY', 'SHAMAN_ANCESTRAL_SPIRIT', nil, target);       
                elseif self.db.char.messagesRandomMount then
                    local itemMountName, _, itemMountTitle = self:InventoryGetMountData();
                    if itemMountName ~= nil and itemMountTitle ~= nil and itemMountTitle == spell then
                        self:DoSpeech('SAY', 'MOUNT', nil, nil, itemMountTitle);
                    end
                end
            end
        end
    end
end

function Totemus:ButtonRememberSpell(menuId, spellId)
    local optionName = 'remember'..menuId;
    if self.temporary == nil then
        self.temporary = {};
    end
    if self.temporary[optionName] == nil then
        self.temporary[optionName] = { 
            [0] = nil, 
            [1] = nil 
        };
    end
    if InCombatLockdown() or self.updatePending then
        if self.db.profile[optionName] then
            if self.db.profile[optionName][0] and self.temporary[optionName][0] == nil then
                self.temporary[optionName][0] = self.db.profile[optionName][0];
            end
            if self.db.profile[optionName][1] and self.temporary[optionName][1] == nil then
                self.temporary[optionName][1] = self.db.profile[optionName][1];
            end
        end
        if self.temporary[optionName][1] ~= spellId then
            if self.temporary[optionName][1] ~= nil then
                self.temporary[optionName][0] = self.temporary[optionName][1];
            else
                self.temporary[optionName][0] = spellId;
            end
            self.temporary[optionName][1] = spellId;        
        end
        self.updatePending = true;
    elseif self.db.profile[optionName] then
        self.temporary[optionName][0] = nil;
        self.temporary[optionName][1] = nil;
        if self.db.profile[optionName][1] and self.db.profile[optionName][1] ~= spellId then
            if self.db.profile[optionName][1] ~= '' then
                self.db.profile[optionName][0] = self.db.profile[optionName][1];
            else
                self.db.profile[optionName][0] = spellId;
            end
            self.db.profile[optionName][1] = spellId;
            self:UpdateActions();
            GameTooltip:Hide();
        end
    end
end

function Totemus:UpdateTemporaryOptions()
    if (not InCombatLockdown()) and self.updatePending then
        if self.temporary == nil then
            self.temporary = {};
            return;
        end        
        for optionName, optionValue in pairs(self.temporary) do
            if type(optionValue) == 'table' then
                for subOptionName, subOptionValue in pairs(optionValue) do
                    if subOptionValue ~= nil then
                        self.db.profile[optionName][subOptionName] = subOptionValue;
                        self.temporary[optionName][subOptionName] = nil;
                    end
                end
            elseif optionValue ~= nil then
                self.db.profile[optionName] = optionValue;
                self.temporary[optionName] = nil;
            end
        end
    end
end


function Totemus:GetButtonCooldownStr(cooldownString, cooldownUnit) 
    if cooldownUnit == 'h' then
        return '|c00FFCC00'..cooldownString..L['BUTTON_COOLDOWN_HOUR']..'|r';
    elseif cooldownUnit == 'm' then
        return '|c00FFCC00'..cooldownString..L['BUTTON_COOLDOWN_MINUTES']..'|r';
    else
        return '|c00FFCC00'..cooldownString..'|r';
    end
end

function Totemus:ButtonRememberSpell(menuId, spellId)
        local optionName = 'remember'..menuId;
        if self.db.char[optionName] then
            if self.db.char[optionName][0] and self.db.char[optionName][0] ~= spellId then
                if self.db.char[optionName][0] ~= '' then
                    self.db.char[optionName][1] = self.db.char[optionName][0];
                else
                    self.db.char[optionName][0] = spellId;
                end
                self.db.char[optionName][0] = spellId;
                self:UpdateActions();
                GameTooltip:Hide();
            end
        end
end

function Totemus:GetTooltipCooldownStr(cooldownString, cooldownUnit) 
    if cooldownUnit == 'h' then
        return L['COOLDOWN_REMAINING']..': '..cooldownString..L['TOOLTIP_COOLDOWN_HOUR'];
    elseif cooldownUnit == 'm' then
        return L['COOLDOWN_REMAINING']..': '..cooldownString..L['TOOLTIP_COOLDOWN_MINUTES'];
    else
        return L['COOLDOWN_REMAINING']..': '..cooldownString..L['TOOLTIP_COOLDOWN_SECONDS'];
    end
end

function Totemus_MinimapToggle() 
  TotemusFuBar:ToggleIconShown();
end